(function () {
    const accordion = document.querySelectorAll('.accordion-toggle');

    function closeAllExcept(currentBtn) {
        accordion.forEach(btn => {
            if (btn !== currentBtn) {
                btn.setAttribute('aria-expanded', 'false');
                const panel = document.getElementById(btn.getAttribute('aria-controls'));
                if (panel) panel.hidden = true;
            }
        });
    }

    accordion.forEach(btn => {
        btn.addEventListener('click', function () {
            const panelId = this.getAttribute('aria-controls');
            const panel = document.getElementById(panelId);
            const isExpanded = this.getAttribute('aria-expanded') === 'true';
           
            // close others
            closeAllExcept(this);

            // toggle current
            if (isExpanded) {
                this.setAttribute('aria-expanded', 'false');
                if (panel) panel.hidden = true;
            } else {
                this.setAttribute('aria-expanded', 'true');
                if (panel) panel.hidden = false;
                // optionally scroll into view a little
                this.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }
        });
    });

    // optional: open the first FAQ by default
    const firstBtn = document.querySelector('.accordion-toggle');
    if (firstBtn) {
        firstBtn.setAttribute('aria-expanded', 'true');
        const firstPanel = document.getElementById(firstBtn.getAttribute('aria-controls'));
        if (firstPanel) firstPanel.hidden = false;
    }
})();
